<?php
/*
 * Plugin Name: Gravity Forms: User Subscription Via Stripe
 * Plugin URI: https://web321.co/plugins/stripeuserreg
 * Description: Handles user registration via Stripe payments using Gravity Forms.
 * Version: 1.0.0
 * Author: Shawn DeWolfe
 * Author URI: https://web321.co/plugins/
 * Donate: https://www.paypal.com/paypalme/web321co/20/
 * Requires at least: 6.1.1
 * Requires PHP: 7.2
 * Tested up to: 6.3.1
 * License: GPL2
 */

define('WSUR_DIR', plugin_dir_path(__FILE__));
define('WSUR_NAME', plugin_basename(__FILE__));
define('WSUR_CODES', plugin_dir_path(__FILE__) . 'shortcodes');
define('WSUR_URL', plugin_dir_url(__FILE__));

// Donation link

function wgfsur_row_meta($links, $file)
{
	if (WSUR_NAME == $file) {
		$row_meta = array(
			'donate' => '<a href="' . esc_url('https://www.paypal.com/paypalme/web321co/20/') . '" target="_blank" aria-label="' . esc_attr__('Donate', 'stripeuserreg_row_meta') . '" >' . esc_html__('Donate', 'stripeuserreg_row_meta') . '</a>'
		);
		$links = array_merge($links, $row_meta);

		if ( !is_plugin_active( 'gravityforms/gravityforms.php' ) ) {
			$row_meta = array(
				'purchase' => '<a href="' . esc_url('http://rocketgenius.pxf.io/anPE3Y') . '" target="_blank" aria-label="' . esc_attr__('Purchase Gravity Forms', 'stripeuserreg_row_meta') . '" >' . esc_html__('Purchase Gravity Forms', 'stripeuserreg_row_meta') . '</a>'
			);
			$links = array_merge($links, $row_meta);
		}

        return $links;
    }
    return (array)$links;
}


if ( is_plugin_active( 'gravityforms/gravityforms.php' ) ) {
	add_action( 'gform_gravityformsuserregistration_post_process_feed', 'wgfsur_process_stripe_payment', 10, 4 );
	add_action('wgfsur_check_subscription_status', 'wgfsur_check_subscription_status');
	add_filter( 'gform_userregistration_feed_settings_fields', 'wgfsur_activation_select', 10, 2 );
	add_filter('plugin_row_meta', 'wgfsur_row_meta', 10, 2);
}

// Include Gravity Forms API
require_once(WP_PLUGIN_DIR . '/gravityforms/gravityforms.php');

function wgfsur_process_stripe_payment($feed, $entry, $form, $addon) {
	if ((rgars($entry,'is_fulfilled') == 1) && (rgars($entry,'payment_status') == 'Active')) {
		// do the user activation	
		$form_id = rgars($entry,'form_id');
		$entry_id = rgars($entry,'id');
		$meta_key = 'activation_key';
		$meta_value = gform_get_meta( $entry_id, $meta_key );
		// error_log('META-46 '. print_r($meta_value, TRUE) . ' - '.  $entry_id  . ' - '.  $meta_key );

		$addon_slug = 'gravityformsuserregistration'; 
		$feeds = GFAPI::get_feeds( null, $form_id, $addon_slug, true );
		// error_log("FEEDS " . print_r($feeds, TRUE));

		require_once( gf_user_registration()->get_base_path() . '/includes/signups.php' );
		$userdata = GFUserSignups::activate_signup( $meta_value );
	}
}

// Function to handle Stripe subscription expiration
function wgfsur_check_subscription_status() {
    // Check if Stripe and User Registration add-ons are active
    $stripe_addon_path = WP_PLUGIN_DIR . '/gravityforms-stripe/stripe.php';
    $user_registration_addon_path = WP_PLUGIN_DIR . '/gravityformsuserregistration/userregistration.php';

    if (is_plugin_active($stripe_addon_path) && is_plugin_active($user_registration_addon_path)) {
        // Both Stripe and User Registration add-ons are active

        // Get the current user's ID
        $user_id = get_current_user_id();

        if ($user_id) {
            // Get the form ID of the form currently being submitted
            $form_id = gform_get_current_form_id();

            if ($form_id) {
                // Retrieve the associated Stripe feed settings for the form
                $stripe_feeds = GFAPI::get_feeds(null, $form_id, 'stripe');

                foreach ($stripe_feeds as $stripe_feed) {
                    // Extract the Stripe secret key from the feed settings
                    $stripe_secret_key = rgar($stripe_feed['meta'], 'api_key');

                    if ($stripe_secret_key) {
                        // Get the Stripe customer ID associated with the user
                        $stripe_customer_id = get_user_meta($user_id, 'stripe_customer_id', true);

                        if ($stripe_customer_id) {
                            // Use the Stripe API to check subscription status
                            \Stripe\Stripe::setApiKey($stripe_secret_key);

                            try {
                                $subscription = \Stripe\Subscription::retrieve($stripe_customer_id);

                                // Check the subscription status (example: active)
                                if ($subscription && $subscription->status === 'active') {
                                    // Subscription is active, you can perform actions here
                                } else {
                                    // Subscription is not active, handle accordingly
                                }
                            } catch (\Stripe\Exception\ApiErrorException $e) {
                                // Handle Stripe API error
                            }
                        }
                    }
                }
            }
        }
    }
}

// Schedule the subscription status check daily
if (!wp_next_scheduled('wgfsur_check_subscription_status')) {
    wp_schedule_event(current_time('timestamp'), 'daily', 'wgfsur_check_subscription_status');
}

function wgfsur_activation_select( $fields, $form ) {
	$new_option = [
		'label' => esc_html__( 'after Stripe payment', 'gravityformsuserregistration' ),
		'value' => 'stripe'
	];

	foreach ($fields['additional_settings']['fields'] as $key => $arr) {
		if ($arr['name'] == 'userActivation') {
			error_log(print_r($fields['additional_settings'], TRUE));
			$fields['additional_settings']['fields'][$key]['select']['choices'][] = $new_option;		
		}
	}
	return $fields;
}