jQuery(document).ready(function($) {
    function fetchTerms() {
        $.ajax({
            url: ajaxurl,
            method: 'POST',
            data: {
                action: 'wai_get_current_page_terms',
                post_id: wp.data.select('core/editor').getCurrentPostId()
            },
            success: function(response) {
                if (response.success) {
                    // Do something with the terms, e.g., populate the fields
                }
            }
        });
    }

    if ($('#use-current-page-terms').is(':checked')) {
        fetchTerms();
    }

    $('#use-current-page-terms').change(function() {
        if ($(this).is(':checked')) {
            fetchTerms();
        }
    });

    // Handle form submission
    $('.custom-block .search-form').on('submit', function(event) {
        event.preventDefault();
        const searchQuery = $(this).find('.search-field').val();
        $.ajax({
            url: wai_ajax_object.ajax_url,
            method: 'POST',
            data: {
                action: 'wai_search_posts',
                s: searchQuery
            },
            success: function(response) {
                if (response.success) {
                    $('.custom-block .search-results').html(response.data);
                } else {
                    $('.custom-block .search-results').html('<p>No posts found.</p>');
                }
            }
        });
    });
});
