(function(wp) {
    const { registerBlockType } = wp.blocks;
    const { InspectorControls } = wp.blockEditor;
    const { PanelBody, CheckboxControl, TextControl } = wp.components;
    const { createElement } = wp.element;

    registerBlockType('wai/block', {
        title: 'Post Archive Index',
        icon: 'universal-access-alt',
        category: 'widgets',
        attributes: {
            categories: {
                type: 'array',
                default: []
            },
            tags: {
                type: 'array',
                default: []
            },
            useCurrentPageTerms: {
                type: 'boolean',
                default: false
            }
        },
        edit: function(props) {
            const { attributes: { categories, tags, useCurrentPageTerms }, setAttributes } = props;

            function onChangeCategories(newCategories) {
                setAttributes({ categories: newCategories.split(',') });
            }

            function onChangeTags(newTags) {
                setAttributes({ tags: newTags.split(',') });
            }

            function onChangeUseCurrentPageTerms(newValue) {
                setAttributes({ useCurrentPageTerms: newValue });
            }

            return createElement(
                'div',
                null,
                createElement(
                    InspectorControls,
                    null,
                    createElement(
                        PanelBody,
                        { title: 'Settings' },
                        createElement(CheckboxControl, {
                            label: 'Use current page categories and tags',
                            checked: useCurrentPageTerms,
                            onChange: onChangeUseCurrentPageTerms
                        }),
                        !useCurrentPageTerms && createElement(
                            'div',
                            null,
                            createElement(TextControl, {
                                label: 'Categories',
                                value: categories.join(','),
                                onChange: function(value) { onChangeCategories(value); }
                            }),
                            createElement(TextControl, {
                                label: 'Tags',
                                value: tags.join(','),
                                onChange: function(value) { onChangeTags(value); }
                            })
                        )
                    )
                ),
                createElement('div', null, 'Post Archive Index')
            );
        },
        save: function() {
            return null; // Use PHP to render
        }
    });
})(window.wp);